var $=Object.defineProperty;var V=(T,e,n)=>e in T?$(T,e,{enumerable:!0,configurable:!0,writable:!0,value:n}):T[e]=n;var F=(T,e,n)=>V(T,typeof e!="symbol"?e+"":e,n);import{b as L,d as j,u as H,h as q,e as W,i as O}from"./storage.js";class Y{constructor(){F(this,"contextMenuIds",{text:"nabu-save-text",image:"nabu-save-image",video:"nabu-save-video",screenshot:"nabu-take-screenshot",pdf:"nabu-save-pdf"});F(this,"lastSessionTokens",null);this.init()}async restoreSession(){var e;try{const s=(await chrome.storage.local.get("supabase_session")).supabase_session;if(s!=null&&s.access_token&&(s!=null&&s.refresh_token)){console.log("🔐 Restoring Supabase session from storage...");const{data:u,error:l}=await L.auth.setSession({access_token:s.access_token,refresh_token:s.refresh_token});l?console.warn("⚠️ Failed to restore session:",l):(this.lastSessionTokens={access_token:s.access_token,refresh_token:s.refresh_token},console.log("✅ Session restored for user:",(e=u==null?void 0:u.user)==null?void 0:e.id))}else console.log("ℹ️ No stored session found")}catch(n){console.error("❌ Error restoring session:",n)}}async ensureSession(){const{data:{session:e}}=await L.auth.getSession();if(e!=null&&e.access_token&&(e!=null&&e.refresh_token))return!0;await this.restoreSession();const{data:{session:n}}=await L.auth.getSession();return!!(n!=null&&n.access_token&&(n!=null&&n.refresh_token))}async init(){console.log("🚀 NabuAI Background Service initializing..."),await this.restoreSession(),this.createContextMenus(),chrome.contextMenus.onClicked.addListener(this.handleContextMenuClick.bind(this)),chrome.runtime.onMessage.addListener(this.handleMessage.bind(this)),chrome.runtime.onInstalled.addListener(this.handleInstallation.bind(this)),console.log("✅ NabuAI Background Service initialized")}createContextMenus(){console.log("🔧 Creating context menus...");try{chrome.contextMenus.removeAll(()=>{console.log("🧹 Removed existing context menus"),chrome.contextMenus.create({id:this.contextMenuIds.text,title:"Save to NabuAI",contexts:["selection"],documentUrlPatterns:["<all_urls>"]},e=>{chrome.runtime.lastError?console.error("❌ Error creating text context menu:",chrome.runtime.lastError.message):console.log("✅ Text context menu created")}),chrome.contextMenus.create({id:this.contextMenuIds.image,title:"Save Image to NabuAI",contexts:["image"],documentUrlPatterns:["<all_urls>"]},e=>{chrome.runtime.lastError?console.error("❌ Error creating image context menu:",chrome.runtime.lastError.message):console.log("✅ Image context menu created")}),chrome.contextMenus.create({id:this.contextMenuIds.video,title:"Save Video to NabuAI",contexts:["video"],documentUrlPatterns:["<all_urls>"]},e=>{chrome.runtime.lastError?console.error("❌ Error creating video context menu:",chrome.runtime.lastError.message):console.log("✅ Video context menu created")}),chrome.contextMenus.create({id:this.contextMenuIds.screenshot,title:"Take Full Screenshot",contexts:["page"],documentUrlPatterns:["<all_urls>"]},e=>{chrome.runtime.lastError?console.error("❌ Error creating screenshot context menu:",chrome.runtime.lastError.message):console.log("✅ Screenshot context menu created")}),chrome.contextMenus.create({id:"nabu-take-partial-screenshot",title:"Select Area to Screenshot",contexts:["page"],documentUrlPatterns:["<all_urls>"]},e=>{chrome.runtime.lastError?console.error("❌ Error creating partial screenshot context menu:",chrome.runtime.lastError.message):console.log("✅ Partial screenshot context menu created")}),chrome.contextMenus.create({id:this.contextMenuIds.pdf,title:"Open PDF in NabuAI Viewer",contexts:["link"],documentUrlPatterns:["<all_urls>"],targetUrlPatterns:["*://*/*.pdf","*://*/*.PDF"]},e=>{chrome.runtime.lastError?console.error("❌ Error creating PDF context menu:",chrome.runtime.lastError.message):console.log("✅ PDF context menu created")}),console.log("🎯 All context menus created successfully")})}catch(e){console.error("❌ Error creating context menus:",e)}}async handleContextMenuClick(e,n){if(console.log("🖱️ Context menu clicked:",e.menuItemId,e),console.log("📋 Context menu data:",{menuItemId:e.menuItemId,srcUrl:e.srcUrl,linkUrl:e.linkUrl,selectionText:e.selectionText,tab:n!=null&&n.id?`Tab ${n.id}`:"No tab"}),!(n!=null&&n.id)){console.error("❌ No tab ID available");try{const[s]=await chrome.tabs.query({active:!0,currentWindow:!0});if(s!=null&&s.id)n=s,console.log("✅ Retrieved active tab:",n.id);else{console.error("❌ Could not retrieve active tab");return}}catch(s){console.error("❌ Error retrieving tab:",s);return}}try{if(e.menuItemId===this.contextMenuIds.text&&e.selectionText)console.log("📝 Text selected, showing save dialog..."),await this.showTextSaveDialog(n.id,e.selectionText,n.url||"");else if(e.menuItemId===this.contextMenuIds.image){if(!e.srcUrl){console.error("❌ Image context menu clicked but no srcUrl available"),console.log("Available info:",e);return}console.log("🖼️ Image selected, showing save dialog...",e.srcUrl),await this.showMediaSaveDialog(n.id,{src:e.srcUrl,alt:e.mediaType==="image"&&e.altText||"Image",url:n.url||"",type:"image"})}else if(e.menuItemId===this.contextMenuIds.video&&e.srcUrl)console.log("🎥 Video selected, showing save dialog..."),await this.showMediaSaveDialog(n.id,{src:e.srcUrl,alt:"Video",url:n.url||"",type:"video"});else if(e.menuItemId===this.contextMenuIds.screenshot)console.log("📸 Full screenshot requested, capturing page..."),await this.takeScreenshot(n.id,n.url||"");else if(e.menuItemId==="nabu-take-partial-screenshot")console.log("📸 Partial screenshot requested, starting selection mode..."),await this.startPartialScreenshot(n.id,n.url||"");else if(e.menuItemId===this.contextMenuIds.pdf&&e.linkUrl){if(e.mediaType==="image"){console.log("🖼️ Image link clicked, ignoring PDF menu (image menu should be used instead)");return}this.isPDFUrl(e.linkUrl)?(console.log("📄 PDF link selected, opening in NabuAI viewer..."),await this.openPDFInViewer(e.linkUrl,n.url||"")):console.log("⚠️ Link is not a PDF, ignoring...")}else console.log("⚠️ Unknown context menu item:",e.menuItemId)}catch(s){console.error("❌ Error handling context menu click:",s)}}async showTextSaveDialog(e,n,s){var u,l,i,v;console.log(`🎬 Injecting text save dialog into tab ${e}`),console.log(`📝 Text: ${n.substring(0,100)}...`),console.log(`🔗 URL: ${s}`);try{await this.ensureSession()||console.warn("⚠️ No session available, cannot fetch scribes");let y=[];try{y=(await j.getUserScribes()||[]).map(a=>({id:a.id,name:a.name||"Untitled"}))}catch(r){console.warn("Failed to load scribes:",r)}let o;try{if(o=await chrome.tabs.get(e),!o||!o.id){console.error("❌ Invalid tab ID:",e);return}if((u=o.url)!=null&&u.startsWith("chrome://")||(l=o.url)!=null&&l.startsWith("chrome-extension://")){console.error("❌ Cannot inject into restricted page:",o.url);return}}catch(r){console.error("❌ Error checking tab:",r);return}let x=!1,h=null;for(let r=0;r<3;r++)try{r>0&&(console.log(`🔄 Retry attempt ${r+1}/3 for script injection`),await new Promise(a=>setTimeout(a,200*r))),await chrome.scripting.executeScript({target:{tabId:e},func:(a,k,C)=>{(document.readyState==="loading"?new Promise(S=>{document.addEventListener("DOMContentLoaded",S,{once:!0})}):Promise.resolve()).then(()=>{if(console.log("🎭 Creating text save dialog in page context..."),document.querySelectorAll("[data-nabu-text-modal]").forEach(t=>{console.log("🧹 Removing existing modal"),t.remove()}),document.querySelectorAll('div[style*="position: fixed"][style*="z-index"]').forEach(t=>{const b=t.innerHTML||"";(b.includes("Save Text")||b.includes("Save to NabuAI"))&&(console.log("🧹 Removing leftover modal"),t.remove())}),!document.body){console.error("❌ Document body not ready");return}const d=document.createElement("div");if(d.setAttribute("data-nabu-text-modal","true"),d.style.cssText=`
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: hsla(0, 0%, 3.9%, 0.8);
            backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 999999;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
          `,!document.querySelector("style[data-nabu-spinner]")){const t=document.createElement("style");t.setAttribute("data-nabu-spinner","true"),t.textContent=`
              @keyframes spin {
                from { transform: rotate(0deg); }
                to { transform: rotate(360deg); }
              }
              .animate-spin {
                animation: spin 1s linear infinite;
              }
            `,document.head.appendChild(t)}d.innerHTML=`
            <div style="
              background: hsl(0, 0%, 9.5%);
              border: 1px solid hsl(0, 0%, 25%);
              border-radius: 0.5rem;
              box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
              max-width: 448px;
              width: 100%;
              margin: 16px;
              max-height: 80vh;
              overflow-y: auto;
            ">
              <div style="
                padding: 16px;
                border-bottom: 1px solid hsl(0, 0%, 25%);
              ">
                <div style="
                  display: flex;
                  align-items: center;
                  justify-content: space-between;
                ">
                  <h3 style="
                    font-size: 18px;
                    font-weight: 600;
                    color: hsl(0, 0%, 98%);
                    margin: 0;
                    letter-spacing: -0.025em;
                  ">Save Text</h3>
                  <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                    color: hsl(0, 0%, 63.9%);
                    background: transparent;
                    border: none;
                    cursor: pointer;
                    padding: 8px;
                    border-radius: 0.375rem;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 15%)'; this.style.color='hsl(0, 0%, 98%)'" onmouseout="this.style.backgroundColor='transparent'; this.style.color='hsl(0, 0%, 63.9%)'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                  </button>
                </div>
              </div>
              
              <div style="padding: 24px; padding-top: 0;">
                <div style="margin-bottom: 16px;">
                  <label style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Selected Text</label>
                  <div style="
                    background: hsl(0, 0%, 9.5%);
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    padding: 12px;
                    font-size: 14px;
                    color: hsl(0, 0%, 98%);
                    max-height: 128px;
                    overflow-y: auto;
                    white-space: pre-wrap;
                    font-family: inherit;
                  ">${a.replace(/</g,"&lt;").replace(/>/g,"&gt;")}</div>
                </div>
                
                <div style="margin-bottom: 16px;">
                  <label style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Page URL</label>
                  <div style="
                    background: hsl(0, 0%, 9.5%);
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    padding: 12px;
                    font-size: 13px;
                    color: hsl(0, 0%, 63.9%);
                    overflow: hidden;
                    text-overflow: ellipsis;
                    white-space: nowrap;
                    font-family: 'Monaco', 'Menlo', monospace;
                  ">${k}</div>
                </div>
                
                <div style="margin-bottom: 20px;">
                  <label for="scribeSelect" style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Scribe</label>
                  <select id="scribeSelect" style="
                    width: 100%;
                    padding: 10px 12px;
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    font-size: 14px;
                    outline: none;
                    box-sizing: border-box;
                    background: hsl(0, 0%, 9.5%);
                    color: hsl(0, 0%, 98%);
                    transition: all 0.2s;
                  " onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'; this.style.borderColor='hsl(0, 0%, 83.1%)'" onblur="this.style.outline='none'; this.style.borderColor='hsl(0, 0%, 25%)'"></select>
                  <div style="margin-top: 10px; display: none;" id="newScribeRow">
                    <input type="text" id="scribeName" style="
                      width: 100%; 
                      padding: 10px 12px; 
                      border: 1px solid hsl(0, 0%, 25%); 
                      border-radius: 0.5rem; 
                      font-size: 14px; 
                      outline: none; 
                      box-sizing: border-box; 
                      background: hsl(0, 0%, 9.5%); 
                      color: hsl(0, 0%, 98%);
                      transition: all 0.2s;
                    " placeholder="New scribe name" onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'; this.style.borderColor='hsl(0, 0%, 83.1%)'" onblur="this.style.outline='none'; this.style.borderColor='hsl(0, 0%, 25%)'">
                  </div>
                </div>
                
                <div style="display: flex; gap: 12px;">
                  <button id="saveBtn" style="
                    flex: 1;
                    background: hsl(0, 0%, 98%);
                    color: hsl(0, 0%, 9%);
                    padding: 10px 16px;
                    border: none;
                    border-radius: 0.5rem;
                    font-size: 14px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    gap: 8px;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"></path>
                    </svg>
                    Save
                  </button>
                  <button onclick="window.open('https://nabu-ai.com/dashboard', '_blank')" style="
                    flex: 1;
                    background: transparent;
                    color: hsl(0, 0%, 98%);
                    padding: 10px 16px;
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    font-size: 14px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    gap: 8px;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 15%)'" onmouseout="this.style.backgroundColor='transparent'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                    </svg>
                    Dashboard
                  </button>
                </div>
              </div>
            </div>
          `,document.body.appendChild(d),console.log("✅ Text save dialog added to page");const f=d.querySelector("#scribeSelect");if(f){const t=document.createElement("option");t.value="",t.text="No scribe",f.appendChild(t);const b=document.createElement("option");b.value="__new__",b.text="➕ Create new scribe",f.appendChild(b),(C||[]).forEach(p=>{const g=document.createElement("option");g.value=p.id,g.text=p.name,f.appendChild(g)}),f.addEventListener("change",()=>{const p=d.querySelector("#newScribeRow");p&&(p.style.display=f.value==="__new__"?"block":"none")})}const M=d.querySelector("#saveBtn");M?(console.log("🔘 Save button found, adding click handler..."),M.addEventListener("click",()=>{var E;console.log("💾 Save button clicked, processing save..."),M.disabled=!0,M.innerHTML=`
                      <svg class="animate-spin" width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                      </svg>
                      Saving...
                    `,M.style.opacity="0.7",M.style.cursor="not-allowed";const t=d.querySelector("#scribeName"),b=((E=t==null?void 0:t.value)==null?void 0:E.trim())||"",p=d.querySelector("#scribeSelect"),g=p!=null&&p.value&&p.value!=="__new__"?p.value:"",_={type:"text",title:a.substring(0,50)+(a.length>50?"...":""),url:k,content:a,timestamp:new Date().toISOString(),scribeName:b,scribeId:g};console.log("📊 Save data prepared:",_),chrome.runtime.sendMessage({action:"saveContent",data:_},w=>{console.log("📨 Save response received:",w),w&&w.success?(d.innerHTML=`
                          <div style="
                            background: hsl(0, 0%, 9.5%);
                            border: 1px solid hsl(0, 0%, 25%);
                            border-radius: 0.5rem;
                            padding: 24px;
                            max-width: 384px;
                            margin: 16px;
                            text-align: center;
                            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                          ">
                            <div style="
                              width: 64px;
                              height: 64px;
                              background: hsl(0, 0%, 15%);
                              border-radius: 50%;
                              display: flex;
                              align-items: center;
                              justify-content: center;
                              margin: 0 auto 16px;
                            ">
                              <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                              </svg>
                            </div>
                            <h3 style="
                              font-size: 20px;
                              font-weight: 600;
                              color: hsl(0, 0%, 98%);
                              margin: 0 0 8px;
                            ">Saved to NabuAI!</h3>
                            <p style="
                              font-size: 14px;
                              color: hsl(0, 0%, 63.9%);
                              margin: 0 0 24px;
                              line-height: 1.5;
                            ">Your text has been successfully saved.</p>
                            <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                              width: 100%;
                              background: hsl(0, 0%, 98%);
                              color: hsl(0, 0%, 9%);
                              padding: 10px 16px;
                              border: none;
                              border-radius: 0.5rem;
                              font-size: 14px;
                              font-weight: 500;
                              cursor: pointer;
                              transition: all 0.2s;
                            " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                              Continue
                            </button>
                          </div>
                        `,console.log("✅ Success message displayed")):(d.innerHTML=`
                          <div style="
                            background: hsl(0, 0%, 9.5%);
                            border: 1px solid hsl(0, 0%, 25%);
                            border-radius: 0.5rem;
                            padding: 24px;
                            max-width: 384px;
                            margin: 16px;
                            text-align: center;
                            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                          ">
                            <div style="
                              width: 64px;
                              height: 64px;
                              background: hsl(0, 62.8%, 30.6%);
                              border-radius: 50%;
                              display: flex;
                              align-items: center;
                              justify-content: center;
                              margin: 0 auto 16px;
                            ">
                              <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                              </svg>
                            </div>
                            <h3 style="
                              font-size: 20px;
                              font-weight: 600;
                              color: hsl(0, 0%, 98%);
                              margin: 0 0 8px;
                            ">Save Failed</h3>
                            <p style="
                              font-size: 14px;
                              color: hsl(0, 0%, 63.9%);
                              margin: 0 0 24px;
                              line-height: 1.5;
                            ">There was an error saving your content. Please try again.</p>
                            <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                              width: 100%;
                              background: hsl(0, 62.8%, 30.6%);
                              color: hsl(0, 0%, 98%);
                              padding: 10px 16px;
                              border: none;
                              border-radius: 0.5rem;
                              font-size: 14px;
                              font-weight: 500;
                              cursor: pointer;
                              transition: all 0.2s;
                            " onmouseover="this.style.backgroundColor='hsl(0, 62.8%, 25.6%)'" onmouseout="this.style.backgroundColor='hsl(0, 62.8%, 30.6%)'">
                              Close
                            </button>
                          </div>
                        `,console.log("❌ Error message displayed"))})}),console.log("✅ Save button click handler added")):console.error("❌ Save button not found"),d.addEventListener("click",t=>{t.target===d&&(d.remove(),console.log("🔒 Modal closed by outside click"))}),document.body.contains(d)||(document.body.appendChild(d),console.log("✅ Modal appended to body")),d.style.display="flex",d.style.visibility="visible",d.style.opacity="1",console.log("✅ Modal should now be visible")}).catch(S=>{console.error("❌ Error in modal creation:",S)})},args:[n,s,y]}),x=!0,console.log("✅ Text save dialog script injected successfully");break}catch(a){if(h=a,console.error(`❌ Script injection attempt ${r+1} failed:`,a),(i=a.message)!=null&&i.includes("Cannot access")||(v=a.message)!=null&&v.includes("restricted")){console.error("❌ Cannot inject into this page type");break}}if(!x){console.error("❌ Failed to inject script after 3 attempts:",h);try{await chrome.tabs.sendMessage(e,{action:"showTextSaveModal",data:{text:n,url:s,scribes:y}}),console.log("✅ Sent message to content script as fallback")}catch(r){console.error("❌ Fallback message also failed:",r)}}}catch(c){console.error("❌ Error showing text save dialog:",c)}}async showMediaSaveDialog(e,n){try{await this.ensureSession()||console.warn("⚠️ No session available, cannot fetch scribes");let u=[];try{console.log("📋 Fetching scribes for media save dialog...");const l=await j.getUserScribes();console.log("📋 Fetched scribes:",(l==null?void 0:l.length)||0,"scribes"),u=(l||[]).map(i=>({id:i.id,name:i.name||"Untitled"})),console.log("📋 Mapped scribes:",u.length,"scribes",u)}catch(l){console.error("❌ Failed to load scribes:",l),console.error("❌ Error details:",{message:l==null?void 0:l.message,stack:l==null?void 0:l.stack,error:l})}await chrome.scripting.executeScript({target:{tabId:e},func:(l,i)=>{console.log("📋 Received scribes in injected script:",(i==null?void 0:i.length)||0,"scribes",i),document.querySelectorAll("[data-nabu-media-modal]").forEach(h=>h.remove());const c=document.createElement("div");c.setAttribute("data-nabu-media-modal","true"),c.style.cssText=`
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: hsla(0, 0%, 3.9%, 0.8);
            backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 999999;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
          `;const y=l.type==="image"?`<img src="${l.src}" alt="${l.alt}" style="width: 100%; height: 128px; object-fit: cover; border-radius: 10px; border: 1px solid rgba(75, 85, 99, 0.5);">`:`<video src="${l.src}" style="width: 100%; height: 128px; object-fit: cover; border-radius: 10px; border: 1px solid rgba(75, 85, 99, 0.5);" controls></video>`;c.innerHTML=`
            <div style="
              background: hsl(0, 0%, 9.5%);
              border: 1px solid hsl(0, 0%, 25%);
              border-radius: 0.5rem;
              box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
              max-width: 448px;
              width: 100%;
              margin: 16px;
              max-height: 80vh;
              overflow-y: auto;
            ">
              <div style="
                padding: 16px;
                border-bottom: 1px solid hsl(0, 0%, 25%);
              ">
                <div style="
                  display: flex;
                  align-items: center;
                  justify-content: space-between;
                ">
                  <h3 style="
                    font-size: 18px;
                    font-weight: 600;
                    color: hsl(0, 0%, 98%);
                    margin: 0;
                    letter-spacing: -0.025em;
                  ">Save ${l.type==="image"?"Image":"Video"}</h3>
                  <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                    color: hsl(0, 0%, 63.9%);
                    background: transparent;
                    border: none;
                    cursor: pointer;
                    padding: 8px;
                    border-radius: 0.375rem;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 15%)'; this.style.color='hsl(0, 0%, 98%)'" onmouseout="this.style.backgroundColor='transparent'; this.style.color='hsl(0, 0%, 63.9%)'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                  </button>
                </div>
              </div>
              
              <div style="padding: 24px; padding-top: 0;">
                <div style="margin-bottom: 16px;">
                  <label style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Preview</label>
                  <div style="background: hsl(0, 0%, 9.5%); padding: 8px; border-radius: 0.5rem; border: 1px solid hsl(0, 0%, 25%);">
                    ${y}
                  </div>
                </div>
                
                <div style="margin-bottom: 16px;">
                  <label style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Media URL</label>
                  <div style="
                    background: hsl(0, 0%, 9.5%);
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    padding: 12px;
                    font-size: 13px;
                    color: hsl(0, 0%, 63.9%);
                    overflow: hidden;
                    text-overflow: ellipsis;
                    white-space: nowrap;
                    font-family: 'Monaco', 'Menlo', monospace;
                  ">${l.src}</div>
                </div>
                
                <div style="margin-bottom: 20px;">
                  <label for="scribeSelect" style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Scribe</label>
                  <select id="scribeSelect" style="
                    width: 100%;
                    padding: 10px 12px;
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    font-size: 14px;
                    outline: none;
                    box-sizing: border-box;
                    background: hsl(0, 0%, 9.5%);
                    color: hsl(0, 0%, 98%);
                    transition: all 0.2s;
                  " onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'; this.style.borderColor='hsl(0, 0%, 83.1%)'" onblur="this.style.outline='none'; this.style.borderColor='hsl(0, 0%, 25%)'"></select>
                  <div style="margin-top: 10px; display: none;" id="newScribeRow">
                    <input type="text" id="scribeName" style="
                      width: 100%; 
                      padding: 10px 12px; 
                      border: 1px solid hsl(0, 0%, 25%); 
                      border-radius: 0.5rem; 
                      font-size: 14px; 
                      outline: none; 
                      box-sizing: border-box; 
                      background: hsl(0, 0%, 9.5%); 
                      color: hsl(0, 0%, 98%);
                      transition: all 0.2s;
                    " placeholder="New scribe name" onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'; this.style.borderColor='hsl(0, 0%, 83.1%)'" onblur="this.style.outline='none'; this.style.borderColor='hsl(0, 0%, 25%)'">
                  </div>
                </div>
                
                <div style="display: flex; gap: 12px;">
                  <button id="saveBtn" style="
                    flex: 1;
                    background: hsl(0, 0%, 98%);
                    color: hsl(0, 0%, 9%);
                    padding: 10px 16px;
                    border: none;
                    border-radius: 0.5rem;
                    font-size: 14px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    gap: 8px;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"></path>
                    </svg>
                    Save
                  </button>
                  <button onclick="window.open('https://nabu-ai.com/dashboard', '_blank')" style="
                    flex: 1;
                    background: transparent;
                    color: hsl(0, 0%, 98%);
                    padding: 10px 16px;
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    font-size: 14px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    gap: 8px;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 15%)'" onmouseout="this.style.backgroundColor='transparent'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                    </svg>
                    Dashboard
                  </button>
                </div>
              </div>
            </div>
          `,document.body.appendChild(c),console.log("✅ Media save dialog added to page");const o=c.querySelector("#scribeSelect");if(o){console.log("📋 Populating media scribe dropdown with",(i==null?void 0:i.length)||0,"scribes");const h=document.createElement("option");h.value="",h.text="No scribe",o.appendChild(h);const r=document.createElement("option");r.value="__new__",r.text="➕ Create new scribe",o.appendChild(r),i&&i.length>0?i.forEach(a=>{const k=document.createElement("option");k.value=a.id,k.text=a.name||"Untitled",o.appendChild(k),console.log("✅ Added scribe option:",a.id,a.name)}):console.warn("⚠️ No scribes available to populate media dropdown"),o.addEventListener("change",()=>{const a=c.querySelector("#newScribeRow");a&&(a.style.display=o.value==="__new__"?"block":"none")})}else console.error("❌ Could not find #scribeSelect element in media modal");if(!document.querySelector("style[data-nabu-spinner]")){const h=document.createElement("style");h.setAttribute("data-nabu-spinner","true"),h.textContent=`
              @keyframes spin {
                from { transform: rotate(0deg); }
                to { transform: rotate(360deg); }
              }
              .animate-spin {
                animation: spin 1s linear infinite;
              }
            `,document.head.appendChild(h)}const x=c.querySelector("#saveBtn");x&&x.addEventListener("click",()=>{var m;x.disabled=!0,x.innerHTML=`
                <svg class="animate-spin" width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Saving...
              `,x.style.opacity="0.7",x.style.cursor="not-allowed";const h=c.querySelector("#scribeSelect"),r=c.querySelector("#scribeName"),a=h!=null&&h.value&&h.value!=="__new__"?h.value:"",k=(h==null?void 0:h.value)==="__new__"&&((m=r==null?void 0:r.value)==null?void 0:m.trim())||"",C={type:l.type,title:l.alt,url:l.url,content:l.src,timestamp:new Date().toISOString(),scribeId:a,scribeName:k,metadata:{mediaType:l.type}};console.log("Saving media to NabuAI:",C),chrome.runtime.sendMessage({action:"saveContent",data:C},S=>{S&&S.success?c.innerHTML=`
                    <div style="
                      background: hsl(0, 0%, 9.5%);
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      padding: 24px;
                      max-width: 384px;
                      margin: 16px;
                      text-align: center;
                      box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                    ">
                      <div style="
                        width: 64px;
                        height: 64px;
                        background: hsl(0, 0%, 15%);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin: 0 auto 16px;
                      ">
                        <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                        </svg>
                      </div>
                      <h3 style="
                        font-size: 20px;
                        font-weight: 600;
                        color: hsl(0, 0%, 98%);
                        margin: 0 0 8px;
                      ">Saved to NabuAI!</h3>
                      <p style="
                        font-size: 14px;
                        color: hsl(0, 0%, 63.9%);
                        margin: 0 0 24px;
                        line-height: 1.5;
                      ">Your ${l.type} has been successfully saved.</p>
                      <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                        width: 100%;
                        background: hsl(0, 0%, 98%);
                        color: hsl(0, 0%, 9%);
                        padding: 10px 16px;
                        border: none;
                        border-radius: 0.5rem;
                        font-size: 14px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s;
                      " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                        Continue
                      </button>
                    </div>
                  `:c.innerHTML=`
                    <div style="
                      background: hsl(0, 0%, 9.5%);
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      padding: 24px;
                      max-width: 384px;
                      margin: 16px;
                      text-align: center;
                      box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                    ">
                      <div style="
                        width: 64px;
                        height: 64px;
                        background: hsl(0, 62.8%, 30.6%);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin: 0 auto 16px;
                      ">
                        <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                      </div>
                      <h3 style="
                        font-size: 20px;
                        font-weight: 600;
                        color: hsl(0, 0%, 98%);
                        margin: 0 0 8px;
                      ">Save Failed</h3>
                      <p style="
                        font-size: 14px;
                        color: hsl(0, 0%, 63.9%);
                        margin: 0 0 24px;
                        line-height: 1.5;
                      ">There was an error saving your content. Please try again.</p>
                      <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                        width: 100%;
                        background: hsl(0, 62.8%, 30.6%);
                        color: hsl(0, 0%, 98%);
                        padding: 10px 16px;
                        border: none;
                        border-radius: 0.5rem;
                        font-size: 14px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s;
                      " onmouseover="this.style.backgroundColor='hsl(0, 62.8%, 25.6%)'" onmouseout="this.style.backgroundColor='hsl(0, 62.8%, 30.6%)'">
                        Close
                      </button>
                    </div>
                  `})}),c.addEventListener("click",h=>{h.target===c&&c.remove()})},args:[n,u]})}catch(s){console.error("Error showing media save dialog:",s)}}isPDFUrl(e){var n;try{const s=new URL(e),u=s.pathname.toLowerCase(),l=s.searchParams;return!!(u.endsWith(".pdf")||l.has("format")&&((n=l.get("format"))==null?void 0:n.toLowerCase())==="pdf"||u.includes(".pdf"))}catch(s){return console.error("Error parsing URL:",s),!1}}async takeScreenshot(e,n){console.log(`📸 Taking screenshot of tab ${e}`),console.log(`🔗 URL: ${n}`);try{const s=await chrome.tabs.captureVisibleTab(null,{format:"png",quality:90});console.log("✅ Screenshot captured successfully"),await this.showScreenshotSaveDialog(e,s,n)}catch(s){console.error("❌ Error taking screenshot:",s),await chrome.scripting.executeScript({target:{tabId:e},func:()=>{const u=document.createElement("div");u.style.cssText=`
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 999999;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
          `,u.innerHTML=`
            <div style="
              background: hsl(0, 0%, 9.5%);
              border: 1px solid hsl(0, 0%, 25%);
              border-radius: 0.5rem;
              padding: 24px;
              max-width: 384px;
              margin: 16px;
              text-align: center;
              box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            ">
              <div style="
                width: 64px;
                height: 64px;
                background: hsl(0, 62.8%, 30.6%);
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 16px;
              ">
                <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
              </div>
              <h3 style="
                font-size: 20px;
                font-weight: 600;
                color: hsl(0, 0%, 98%);
                margin: 0 0 8px;
              ">Screenshot Failed</h3>
              <p style="
                font-size: 14px;
                color: hsl(0, 0%, 63.9%);
                margin: 0 0 24px;
                line-height: 1.5;
              ">Unable to capture screenshot. Please try again.</p>
              <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                width: 100%;
                background: hsl(0, 62.8%, 30.6%);
                color: hsl(0, 0%, 98%);
                padding: 10px 16px;
                border: none;
                border-radius: 0.5rem;
                font-size: 14px;
                font-weight: 500;
                cursor: pointer;
                transition: all 0.2s;
              " onmouseover="this.style.backgroundColor='hsl(0, 62.8%, 25.6%)'" onmouseout="this.style.backgroundColor='hsl(0, 62.8%, 30.6%)'">
                Close
              </button>
            </div>
          `,document.body.appendChild(u),u.addEventListener("click",l=>{l.target===u&&u.remove()})}})}}async startPartialScreenshot(e,n){console.log(`📸 Starting partial screenshot selection for tab ${e}`),console.log(`🔗 URL: ${n}`);try{await this.ensureSession()||console.warn("⚠️ No session available, cannot fetch scribes");let u=[];try{console.log("📋 Fetching scribes for partial screenshot...");const i=await j.getUserScribes();console.log("📋 Fetched scribes:",(i==null?void 0:i.length)||0,"scribes"),u=(i||[]).map(v=>({id:v.id,name:v.name||"Untitled"})),console.log("📋 Mapped scribes:",u.length,"scribes",u)}catch(i){console.error("❌ Failed to load scribes:",i),console.error("❌ Error details:",{message:i==null?void 0:i.message,stack:i==null?void 0:i.stack,error:i})}const l=await chrome.tabs.captureVisibleTab(null,{format:"png",quality:90});console.log("✅ Full screenshot captured for selection"),console.log("📋 About to inject script with scribes:",u.length,"scribes",u),await chrome.scripting.executeScript({target:{tabId:e},func:(i,v,c)=>{console.log("🎭 Creating partial screenshot selection overlay..."),console.log("📋 Received scribes in partial screenshot overlay:",(c==null?void 0:c.length)||0,"scribes",c);const y=document.createElement("div");y.id="nabu-screenshot-overlay",y.style.cssText=`
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.3);
            z-index: 999999;
            cursor: crosshair;
            user-select: none;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
          `;const o=document.createElement("div");o.id="nabu-selection-rect",o.style.cssText=`
            position: absolute;
            border: 2px solid #3b82f6;
            background: rgba(59, 130, 246, 0.1);
            display: none;
            pointer-events: none;
          `;const x=document.createElement("div");x.style.cssText=`
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 12px 20px;
            border-radius: 6px;
            font-size: 14px;
            z-index: 1000000;
            pointer-events: none;
          `,x.textContent="Click and drag to select area (release to capture or press Escape to cancel)",y.appendChild(o),y.appendChild(x),document.body.appendChild(y);let h=!1,r=0,a=0,k=0,C=0;y.addEventListener("mousedown",d=>{h=!0,r=d.clientX,a=d.clientY,k=d.clientX,C=d.clientY,o.style.display="block",o.style.left=r+"px",o.style.top=a+"px",o.style.width="0px",o.style.height="0px",d.preventDefault()}),y.addEventListener("mousemove",d=>{if(!h)return;k=d.clientX,C=d.clientY;const f=Math.min(r,k),M=Math.min(a,C),t=Math.abs(k-r),b=Math.abs(C-a);o.style.left=f+"px",o.style.top=M+"px",o.style.width=t+"px",o.style.height=b+"px",d.preventDefault()}),y.addEventListener("mouseup",d=>{if(!h)return;h=!1,d.preventDefault();const f=o.getBoundingClientRect();f.width>10&&f.height>10?m(i,f,v):(z("Please select a larger area"),y.remove())}),y.addEventListener("keydown",d=>{d.key==="Escape"&&y.remove()}),y.tabIndex=0,y.focus();function m(d,f,M){console.log("📸 Capturing selected area:",f);const t=document.createElement("canvas"),b=t.getContext("2d");if(!b){z("Failed to create canvas context");return}const p=window.devicePixelRatio||1;console.log("📐 Device Pixel Ratio:",p),t.width=f.width,t.height=f.height;const g=new Image;g.onload=()=>{const _=f.left*p,E=f.top*p,w=f.width*p,I=f.height*p;console.log("🎯 Source coordinates:",{sourceX:_,sourceY:E,sourceWidth:w,sourceHeight:I}),console.log("📏 Image dimensions:",{width:g.width,height:g.height}),b.drawImage(g,_,E,w,I,0,0,f.width,f.height);const U=t.toDataURL("image/png",.9);y.remove(),console.log("📋 Calling showScreenshotSaveDialog with scribes:",(c==null?void 0:c.length)||0,"scribes",c),S(U,M,!0,c)},g.onerror=()=>{z("Failed to load screenshot image")},g.src=d}function S(d,f,M,t){const b=t;console.log("🎭 Creating screenshot save dialog..."),console.log("📋 Received scribes in showScreenshotSaveDialog:",(b==null?void 0:b.length)||0,"scribes",b),document.querySelectorAll("[data-nabu-screenshot-modal]").forEach(w=>w.remove());const g=document.createElement("div");g.setAttribute("data-nabu-screenshot-modal","true"),g.style.cssText=`
              position: fixed;
              top: 0;
              left: 0;
              width: 100vw;
              height: 100vh;
              background: hsla(0, 0%, 3.9%, 0.8);
              backdrop-filter: blur(8px);
              display: flex;
              align-items: center;
              justify-content: center;
              z-index: 999999;
              font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            `,g.innerHTML=`
              <div style="
                background: hsl(0, 0%, 9.5%);
                border: 1px solid hsl(0, 0%, 25%);
                border-radius: 0.5rem;
                box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                max-width: 500px;
                width: 100%;
                margin: 16px;
                max-height: 90vh;
                overflow-y: auto;
              ">
                <div style="
                  padding: 16px;
                  border-bottom: 1px solid hsl(0, 0%, 25%);
                ">
                  <div style="
                    display: flex;
                    align-items: center;
                    justify-content: space-between;
                  ">
                    <h3 style="
                      font-size: 18px;
                      font-weight: 600;
                      color: hsl(0, 0%, 98%);
                      margin: 0;
                      letter-spacing: -0.025em;
                    ">Save ${M?"Partial ":""}Screenshot</h3>
                    <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                      color: hsl(0, 0%, 63.9%);
                      background: transparent;
                      border: none;
                      cursor: pointer;
                      padding: 8px;
                      border-radius: 0.375rem;
                      transition: all 0.2s;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                    " onmouseover="this.style.backgroundColor='hsl(0, 0%, 25%)'; this.style.color='hsl(0, 0%, 98%)'" onmouseout="this.style.backgroundColor='transparent'; this.style.color='hsl(0, 0%, 63.9%)'">
                      <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                      </svg>
                    </button>
                  </div>
                </div>
                
                <div style="padding: 24px; padding-top: 0;">
                  <div style="margin-bottom: 16px;">
                    <label style="
                      display: block;
                      font-size: 14px;
                      font-weight: 500;
                      color: hsl(0, 0%, 98%);
                      margin-bottom: 8px;
                    ">Screenshot Preview</label>
                    <div style="
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      overflow: hidden;
                      max-height: 300px;
                      text-align: center;
                      background: hsl(0, 0%, 9.5%);
                      padding: 8px;
                    ">
                      <img src="${d}" alt="Screenshot" style="
                        max-width: 100%;
                        max-height: 300px;
                        object-fit: contain;
                        border-radius: 0.375rem;
                      ">
                    </div>
                  </div>
                  
                  <div style="margin-bottom: 16px;">
                    <label style="
                      display: block;
                      font-size: 14px;
                      font-weight: 500;
                      color: hsl(0, 0%, 98%);
                      margin-bottom: 8px;
                    ">Page URL</label>
                    <div style="
                      background: hsl(0, 0%, 9.5%);
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      padding: 12px;
                      font-size: 13px;
                      color: hsl(0, 0%, 63.9%);
                      overflow: hidden;
                      text-overflow: ellipsis;
                      white-space: nowrap;
                      font-family: 'Monaco', 'Menlo', monospace;
                    ">${f}</div>
                  </div>
                  
                  <div style="margin-bottom: 20px;">
                    <label for="screenshot-scribeSelect" style="
                      display: block;
                      font-size: 14px;
                      font-weight: 500;
                      color: hsl(0, 0%, 98%);
                      margin-bottom: 8px;
                    ">Scribe</label>
                    <select id="screenshot-scribeSelect" style="
                      width: 100%;
                      padding: 10px 12px;
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      font-size: 14px;
                      outline: none;
                      box-sizing: border-box;
                      background: hsl(0, 0%, 9.5%);
                      color: hsl(0, 0%, 98%);
                      transition: all 0.2s;
                    " onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'" onblur="this.style.outline='none'"></select>
                    <div style="margin-top: 10px; display: none;" id="screenshot-newScribeRow">
                      <input type="text" id="screenshot-scribeName" style="
                        width: 100%; 
                        padding: 10px 12px; 
                        border: 1px solid hsl(0, 0%, 25%); 
                        border-radius: 0.5rem; 
                        font-size: 14px; 
                        outline: none; 
                        box-sizing: border-box; 
                        background: hsl(0, 0%, 9.5%); 
                        color: hsl(0, 0%, 98%);
                        transition: all 0.2s;
                      " placeholder="New scribe name" onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'; this.style.borderColor='hsl(0, 0%, 83.1%)'" onblur="this.style.outline='none'; this.style.borderColor='hsl(0, 0%, 25%)'">
                    </div>
                  </div>
                  
                  <div style="display: flex; gap: 12px;">
                    <button id="saveScreenshotBtn" style="
                      flex: 1;
                      background: hsl(0, 0%, 98%);
                      color: hsl(0, 0%, 9%);
                      padding: 10px 16px;
                      border: none;
                      border-radius: 0.5rem;
                      font-size: 14px;
                      font-weight: 500;
                      cursor: pointer;
                      transition: all 0.2s;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      gap: 8px;
                    " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                      <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"></path>
                      </svg>
                      Save Screenshot
                    </button>
                    <button onclick="window.open('https://nabu-ai.com/dashboard', '_blank')" style="
                      flex: 1;
                      background: transparent;
                      color: hsl(0, 0%, 98%);
                      padding: 10px 16px;
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      font-size: 14px;
                      font-weight: 500;
                      cursor: pointer;
                      transition: all 0.2s;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      gap: 8px;
                    " onmouseover="this.style.backgroundColor='hsl(0, 0%, 25%)'" onmouseout="this.style.backgroundColor='transparent'">
                      <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                      </svg>
                      Dashboard
                    </button>
                  </div>
                </div>
              </div>
            `,document.body.appendChild(g),console.log("✅ Screenshot save dialog added to page");const _=g.querySelector("#screenshot-scribeSelect");if(_){console.log("📋 Populating partial screenshot scribe dropdown with",(b==null?void 0:b.length)||0,"scribes");const w=document.createElement("option");w.value="",w.text="No scribe",_.appendChild(w);const I=document.createElement("option");I.value="__new__",I.text="➕ Create new scribe",_.appendChild(I),b&&b.length>0?b.forEach(U=>{const D=document.createElement("option");D.value=U.id,D.text=U.name||"Untitled",_.appendChild(D),console.log("✅ Added scribe option:",U.id,U.name)}):console.warn("⚠️ No scribes available to populate partial screenshot dropdown"),_.addEventListener("change",()=>{const U=g.querySelector("#screenshot-newScribeRow");U&&(U.style.display=_.value==="__new__"?"block":"none")})}else console.error("❌ Could not find #screenshot-scribeSelect element in partial screenshot modal");if(!document.querySelector("style[data-nabu-spinner]")){const w=document.createElement("style");w.setAttribute("data-nabu-spinner","true"),w.textContent=`
                @keyframes spin {
                  from { transform: rotate(0deg); }
                  to { transform: rotate(360deg); }
                }
                .animate-spin {
                  animation: spin 1s linear infinite;
                }
              `,document.head.appendChild(w)}const E=g.querySelector("#saveScreenshotBtn");E?(console.log("🔘 Save screenshot button found, adding click handler..."),E.addEventListener("click",()=>{var N;console.log("💾 Save screenshot button clicked, processing save..."),E.disabled=!0,E.innerHTML=`
                  <svg class="animate-spin" width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                  </svg>
                  Saving...
                `,E.style.opacity="0.7",E.style.cursor="not-allowed";const w=g.querySelector("#screenshot-scribeSelect"),I=g.querySelector("#screenshot-scribeName"),U=M?"Partial Screenshot":"Screenshot",D=w!=null&&w.value&&w.value!=="__new__"?w.value:"",R=(w==null?void 0:w.value)==="__new__"&&((N=I==null?void 0:I.value)==null?void 0:N.trim())||"",B={type:"image",title:U,url:f,content:d,tags:[],timestamp:new Date().toISOString(),isScreenshot:!0,scribeId:D,scribeName:R,metadata:{isScreenshot:!0,isPartial:M}};console.log("📊 Screenshot save data prepared:",B),chrome.runtime.sendMessage({action:"saveContent",data:B},P=>{console.log("📨 Screenshot save response received:",P),P&&P.success?(g.innerHTML=`
                      <div style="
                        background: hsl(0, 0%, 9.5%);
                        border: 1px solid hsl(0, 0%, 25%);
                        border-radius: 0.5rem;
                        padding: 24px;
                        max-width: 384px;
                        margin: 16px;
                        text-align: center;
                        box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                      ">
                        <div style="
                          width: 64px;
                          height: 64px;
                          background: hsl(0, 0%, 15%);
                          border-radius: 50%;
                          display: flex;
                          align-items: center;
                          justify-content: center;
                          margin: 0 auto 16px;
                        ">
                          <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                          </svg>
                        </div>
                        <h3 style="
                          font-size: 20px;
                          font-weight: 600;
                          color: hsl(0, 0%, 98%);
                          margin: 0 0 8px;
                        ">Screenshot Saved!</h3>
                        <p style="
                          font-size: 14px;
                          color: hsl(0, 0%, 63.9%);
                          margin: 0 0 24px;
                          line-height: 1.5;
                        ">Your ${M?"partial ":""}screenshot has been successfully saved to NabuAI.</p>
                        <button id="continueBtn" style="
                          width: 100%;
                          background: hsl(0, 0%, 98%);
                          color: hsl(0, 0%, 9%);
                          padding: 10px 16px;
                          border: none;
                          border-radius: 0.5rem;
                          font-size: 14px;
                          font-weight: 500;
                          cursor: pointer;
                          transition: all 0.2s;
                        " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                          Continue
                        </button>
                      </div>
                    `,console.log("✅ Screenshot success message displayed"),setTimeout(()=>{const A=g.querySelector("#continueBtn");A&&A.addEventListener("click",()=>{console.log("🔘 Continue button clicked, removing modal"),g.remove()})},100)):(g.innerHTML=`
                      <div style="
                        background: hsl(0, 0%, 9.5%);
                        border: 1px solid hsl(0, 0%, 25%);
                        border-radius: 0.5rem;
                        padding: 24px;
                        max-width: 384px;
                        margin: 16px;
                        text-align: center;
                        box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                      ">
                        <div style="
                          width: 64px;
                          height: 64px;
                          background: hsl(0, 62.8%, 30.6%);
                          border-radius: 50%;
                          display: flex;
                          align-items: center;
                          justify-content: center;
                          margin: 0 auto 16px;
                        ">
                          <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                          </svg>
                        </div>
                        <h3 style="
                          font-size: 20px;
                          font-weight: 600;
                          color: hsl(0, 0%, 98%);
                          margin: 0 0 8px;
                        ">Save Failed</h3>
                        <p style="
                          font-size: 14px;
                          color: hsl(0, 0%, 63.9%);
                          margin: 0 0 24px;
                          line-height: 1.5;
                        ">There was an error saving your screenshot. Please try again.</p>
                        <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                          width: 100%;
                          background: hsl(0, 62.8%, 30.6%);
                          color: hsl(0, 0%, 98%);
                          padding: 10px 16px;
                          border: none;
                          border-radius: 0.5rem;
                          font-size: 14px;
                          font-weight: 500;
                          cursor: pointer;
                          transition: all 0.2s;
                        " onmouseover="this.style.backgroundColor='hsl(0, 62.8%, 25.6%)'" onmouseout="this.style.backgroundColor='hsl(0, 62.8%, 30.6%)'">
                          Close
                        </button>
                      </div>
                    `,console.log("❌ Screenshot error message displayed"))})}),console.log("✅ Screenshot save button click handler added")):console.error("❌ Screenshot save button not found"),g.addEventListener("click",w=>{console.log("🔒 Screenshot modal clicked",w.target),w.target===g&&(g.remove(),console.log("🔒 Screenshot modal closed by outside click"))})}function z(d){const f=document.createElement("div");f.style.cssText=`
              position: fixed;
              top: 20px;
              left: 50%;
              transform: translateX(-50%);
              background: #dc2626;
              color: white;
              padding: 12px 20px;
              border-radius: 6px;
              font-size: 14px;
              z-index: 1000001;
              pointer-events: none;
            `,f.textContent=d,document.body.appendChild(f),setTimeout(()=>{f.remove()},3e3)}},args:[l,n,u]}),console.log("✅ Partial screenshot selection overlay injected successfully")}catch(s){console.error("❌ Error starting partial screenshot:",s)}}async openPDFInViewer(e,n){console.log(`📄 Opening PDF in NabuAI viewer: ${e}`),console.log(`🔗 Source URL: ${n}`);try{const s=chrome.runtime.getURL("pdf-viewer.html"),u=new URLSearchParams({url:e,source:n}),l=`${s}?${u.toString()}`;console.log("🔗 Opening PDF viewer:",l),await chrome.tabs.create({url:l,active:!0}),console.log("✅ PDF viewer opened successfully")}catch(s){console.error("❌ Error opening PDF viewer:",s)}}async showScreenshotSaveDialog(e,n,s){console.log(`🎬 Showing screenshot save dialog for tab ${e}`);try{await this.ensureSession()||console.warn("⚠️ No session available, cannot fetch scribes");let l=[];try{console.log("📋 Fetching scribes for screenshot save dialog...");const i=await j.getUserScribes();console.log("📋 Fetched scribes:",(i==null?void 0:i.length)||0,"scribes"),l=(i||[]).map(v=>({id:v.id,name:v.name||"Untitled"})),console.log("📋 Mapped scribes:",l.length,"scribes",l)}catch(i){console.error("❌ Failed to load scribes:",i),console.error("❌ Error details:",{message:i==null?void 0:i.message,stack:i==null?void 0:i.stack,error:i})}await chrome.scripting.executeScript({target:{tabId:e},func:(i,v,c)=>{console.log("📋 Received scribes in injected script:",(c==null?void 0:c.length)||0,"scribes",c),console.log("🎭 Creating screenshot save dialog in page context..."),document.querySelectorAll("[data-nabu-screenshot-modal]").forEach(r=>r.remove());const o=document.createElement("div");o.setAttribute("data-nabu-screenshot-modal","true"),o.style.cssText=`
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 999999;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
          `,o.innerHTML=`
            <div style="
              background: hsl(0, 0%, 9.5%);
              border: 1px solid hsl(0, 0%, 25%);
              border-radius: 0.5rem;
              box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
              max-width: 500px;
              width: 100%;
              margin: 16px;
              max-height: 90vh;
              overflow-y: auto;
            ">
              <div style="
                padding: 16px;
                border-bottom: 1px solid hsl(0, 0%, 25%);
              ">
                <div style="
                  display: flex;
                  align-items: center;
                  justify-content: space-between;
                ">
                  <h3 style="
                    font-size: 18px;
                    font-weight: 600;
                    color: hsl(0, 0%, 98%);
                    margin: 0;
                    letter-spacing: -0.025em;
                  ">Save Screenshot to NabuAI</h3>
                  <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                    color: hsl(0, 0%, 63.9%);
                    background: transparent;
                    border: none;
                    cursor: pointer;
                    padding: 8px;
                    border-radius: 0.375rem;
                    transition: all 0.2s;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 25%)'; this.style.color='hsl(0, 0%, 98%)'" onmouseout="this.style.backgroundColor='transparent'; this.style.color='hsl(0, 0%, 63.9%)'">
                    <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                  </button>
                </div>
              </div>
              
              <div style="padding: 24px; padding-top: 0;">
                <div style="margin-bottom: 16px;">
                  <label style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Screenshot Preview</label>
                  <div style="
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    overflow: hidden;
                    max-height: 300px;
                    text-align: center;
                    background: hsl(0, 0%, 9.5%);
                    padding: 8px;
                  ">
                    <img src="${i}" alt="Screenshot" style="
                      max-width: 100%;
                      max-height: 300px;
                      object-fit: contain;
                      border-radius: 0.375rem;
                    ">
                  </div>
                </div>
                
                <div style="margin-bottom: 16px;">
                  <label style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Page URL</label>
                  <div style="
                    background: hsl(0, 0%, 9.5%);
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    padding: 12px;
                    font-size: 13px;
                    color: hsl(0, 0%, 63.9%);
                    overflow: hidden;
                    text-overflow: ellipsis;
                    white-space: nowrap;
                    font-family: 'Monaco', 'Menlo', monospace;
                  ">${v}</div>
                </div>
                
                <div style="margin-bottom: 20px;">
                  <label for="screenshot-scribeSelect" style="
                    display: block;
                    font-size: 14px;
                    font-weight: 500;
                    color: hsl(0, 0%, 98%);
                    margin-bottom: 8px;
                  ">Scribe</label>
                  <select id="screenshot-scribeSelect" style="
                    width: 100%;
                    padding: 10px 12px;
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    font-size: 14px;
                    outline: none;
                    box-sizing: border-box;
                    background: hsl(0, 0%, 9.5%);
                    color: hsl(0, 0%, 98%);
                    transition: all 0.2s;
                  " onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'" onblur="this.style.outline='none'"></select>
                  <div style="margin-top: 10px; display: none;" id="screenshot-newScribeRow">
                    <input type="text" id="screenshot-scribeName" style="
                      width: 100%; 
                      padding: 10px 12px; 
                      border: 1px solid hsl(0, 0%, 25%); 
                      border-radius: 0.5rem; 
                      font-size: 14px; 
                      outline: none; 
                      box-sizing: border-box; 
                      background: hsl(0, 0%, 9.5%); 
                      color: hsl(0, 0%, 98%);
                      transition: all 0.2s;
                    " placeholder="New scribe name" onfocus="this.style.outline='2px solid hsl(0, 0%, 83.1%)'; this.style.outlineOffset='2px'; this.style.borderColor='hsl(0, 0%, 83.1%)'" onblur="this.style.outline='none'; this.style.borderColor='hsl(0, 0%, 25%)'">
                  </div>
                </div>
                
                <div style="display: flex; gap: 12px;">
                  <button id="saveScreenshotBtn" style="
                    flex: 1;
                    background: hsl(0, 0%, 98%);
                    color: hsl(0, 0%, 9%);
                    padding: 10px 16px;
                    border: none;
                    border-radius: 0.5rem;
                    font-size: 14px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                    Save Screenshot
                  </button>
                  <button onclick="window.open('https://nabu-ai.com/dashboard', '_blank')" style="
                    flex: 1;
                    background: transparent;
                    color: hsl(0, 0%, 98%);
                    padding: 10px 16px;
                    border: 1px solid hsl(0, 0%, 25%);
                    border-radius: 0.5rem;
                    font-size: 14px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                  " onmouseover="this.style.backgroundColor='hsl(0, 0%, 25%)'" onmouseout="this.style.backgroundColor='transparent'">
                    Go to Dashboard
                  </button>
                </div>
              </div>
            </div>
          `,document.body.appendChild(o),console.log("✅ Screenshot save dialog added to page");const x=o.querySelector("#screenshot-scribeSelect");if(x){console.log("📋 Populating screenshot scribe dropdown with",(c==null?void 0:c.length)||0,"scribes");const r=document.createElement("option");r.value="",r.text="No scribe",x.appendChild(r);const a=document.createElement("option");a.value="__new__",a.text="➕ Create new scribe",x.appendChild(a),c&&c.length>0?c.forEach(k=>{const C=document.createElement("option");C.value=k.id,C.text=k.name||"Untitled",x.appendChild(C),console.log("✅ Added scribe option:",k.id,k.name)}):console.warn("⚠️ No scribes available to populate screenshot dropdown"),x.addEventListener("change",()=>{const k=o.querySelector("#screenshot-newScribeRow");k&&(k.style.display=x.value==="__new__"?"block":"none")})}else console.error("❌ Could not find #screenshot-scribeSelect element in modal");if(!document.querySelector("style[data-nabu-spinner]")){const r=document.createElement("style");r.setAttribute("data-nabu-spinner","true"),r.textContent=`
              @keyframes spin {
                from { transform: rotate(0deg); }
                to { transform: rotate(360deg); }
              }
              .animate-spin {
                animation: spin 1s linear infinite;
              }
            `,document.head.appendChild(r)}const h=o.querySelector("#saveScreenshotBtn");h?(console.log("🔘 Save screenshot button found, adding click handler..."),h.addEventListener("click",()=>{var z;console.log("💾 Save screenshot button clicked, processing save..."),h.disabled=!0,h.innerHTML=`
                <svg class="animate-spin" width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="display: inline-block; margin-right: 8px;">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Saving...
              `,h.style.opacity="0.7",h.style.cursor="not-allowed";const r=o.querySelector("#screenshot-scribeSelect"),a=o.querySelector("#screenshot-scribeName"),k="Screenshot",C=r!=null&&r.value&&r.value!=="__new__"?r.value:"",m=(r==null?void 0:r.value)==="__new__"&&((z=a==null?void 0:a.value)==null?void 0:z.trim())||"",S={type:"image",title:k,url:v,content:i,tags:[],timestamp:new Date().toISOString(),isScreenshot:!0,scribeId:C,scribeName:m,metadata:{isScreenshot:!0}};console.log("📊 Screenshot save data prepared:",S),chrome.runtime.sendMessage({action:"saveContent",data:S},d=>{console.log("📨 Screenshot save response received:",d),d&&d.success?(o.innerHTML=`
                    <div style="
                      background: hsl(0, 0%, 9.5%);
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      padding: 24px;
                      max-width: 384px;
                      margin: 16px;
                      text-align: center;
                      box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                    ">
                      <div style="
                        width: 64px;
                        height: 64px;
                        background: hsl(0, 0%, 15%);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin: 0 auto 16px;
                      ">
                        <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                        </svg>
                      </div>
                      <h3 style="
                        font-size: 20px;
                        font-weight: 600;
                        color: hsl(0, 0%, 98%);
                        margin: 0 0 8px;
                      ">Screenshot Saved!</h3>
                      <p style="
                        font-size: 14px;
                        color: hsl(0, 0%, 63.9%);
                        margin: 0 0 24px;
                        line-height: 1.5;
                      ">Your screenshot has been successfully saved to NabuAI.</p>
                      <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                        width: 100%;
                        background: hsl(0, 0%, 98%);
                        color: hsl(0, 0%, 9%);
                        padding: 10px 16px;
                        border: none;
                        border-radius: 0.5rem;
                        font-size: 14px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s;
                      " onmouseover="this.style.backgroundColor='hsl(0, 0%, 90%)'" onmouseout="this.style.backgroundColor='hsl(0, 0%, 98%)'">
                        Continue
                      </button>
                    </div>
                  `,console.log("✅ Screenshot success message displayed")):(o.innerHTML=`
                    <div style="
                      background: hsl(0, 0%, 9.5%);
                      border: 1px solid hsl(0, 0%, 25%);
                      border-radius: 0.5rem;
                      padding: 24px;
                      max-width: 384px;
                      margin: 16px;
                      text-align: center;
                      box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                    ">
                      <div style="
                        width: 64px;
                        height: 64px;
                        background: hsl(0, 62.8%, 30.6%);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin: 0 auto 16px;
                      ">
                        <svg width="32" height="32" fill="none" stroke="hsl(0, 0%, 98%)" stroke-width="2.5" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                      </div>
                      <h3 style="
                        font-size: 20px;
                        font-weight: 600;
                        color: hsl(0, 0%, 98%);
                        margin: 0 0 8px;
                      ">Save Failed</h3>
                      <p style="
                        font-size: 14px;
                        color: hsl(0, 0%, 63.9%);
                        margin: 0 0 24px;
                        line-height: 1.5;
                      ">There was an error saving your screenshot. Please try again.</p>
                      <button onclick="this.closest('[style*="position: fixed"]').remove()" style="
                        width: 100%;
                        background: hsl(0, 62.8%, 30.6%);
                        color: hsl(0, 0%, 98%);
                        padding: 10px 16px;
                        border: none;
                        border-radius: 0.5rem;
                        font-size: 14px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s;
                      " onmouseover="this.style.backgroundColor='hsl(0, 62.8%, 25.6%)'" onmouseout="this.style.backgroundColor='hsl(0, 62.8%, 30.6%)'">
                        Close
                      </button>
                    </div>
                  `,console.log("❌ Screenshot error message displayed"))})}),console.log("✅ Screenshot save button click handler added")):console.error("❌ Screenshot save button not found"),o.addEventListener("click",r=>{r.target===o&&(o.remove(),console.log("🔒 Screenshot modal closed by outside click"))})},args:[n,s,l]}),console.log("✅ Screenshot save dialog script injected successfully")}catch(u){console.error("❌ Error showing screenshot save dialog:",u)}}handleMessage(e,n,s){var u,l,i;if(e.action==="showTextSaveModal")this.showTextSaveDialog(((u=n.tab)==null?void 0:u.id)||0,e.data.text,e.data.url),s({success:!0});else if(e.action==="showMediaSaveModal")this.showMediaSaveDialog(((l=n.tab)==null?void 0:l.id)||0,e.data),s({success:!0});else{if(e.action==="setAuthSession")return(async()=>{var v,c,y;try{const{access_token:o,refresh_token:x}=e;if(o&&x){if(((v=this.lastSessionTokens)==null?void 0:v.access_token)===o&&((c=this.lastSessionTokens)==null?void 0:c.refresh_token)===x){s({success:!0,skipped:!0});return}await chrome.storage.local.set({supabase_session:{access_token:o,refresh_token:x}});const{data:h,error:r}=await L.auth.setSession({access_token:o,refresh_token:x});r?(console.warn("⚠️ Failed to set Supabase session in background:",r),s({success:!1,error:r.message})):(this.lastSessionTokens={access_token:o,refresh_token:x},console.log("🔐 Supabase session set in background for user:",(y=h==null?void 0:h.user)==null?void 0:y.id),s({success:!0}))}else s({success:!1,error:"Missing tokens"})}catch(o){console.error("❌ Error setting session in background:",o),s({success:!1,error:(o==null?void 0:o.message)||"Unknown error"})}})(),!0;if(e.action==="getUserScribes")return(async()=>{try{if(!await this.ensureSession())throw new Error("Not authenticated");const y=(await j.getUserScribes()||[]).map(o=>({id:o.id,name:o.name||"Untitled",is_shared:o.is_shared||!1}));s({success:!0,scribes:y})}catch(v){console.error("❌ Error fetching scribes for PDF viewer:",v),s({success:!1,error:(v==null?void 0:v.message)||"Failed to load scribes"})}})(),!0;if(e.action==="clearAuthSession")return(async()=>{try{await L.auth.signOut(),await chrome.storage.local.remove("supabase_session"),this.lastSessionTokens=null,console.log("🔐 Auth session cleared in background"),s({success:!0})}catch(v){console.error("❌ Error clearing session in background:",v),s({success:!1,error:(v==null?void 0:v.message)||"Unknown error"})}})(),!0;if(e.action==="saveContent")return this.saveContent(e.data,s,(i=n.tab)==null?void 0:i.id),!0;if(e.action==="openPDFViewer"){const v=e.pdfUrl,c=e.sourceUrl||e.pdfUrl;if(!v){console.warn("⚠️ openPDFViewer request missing pdfUrl"),s({success:!1,error:"Missing pdfUrl"});return}return(async()=>{try{await this.openPDFInViewer(v,c),s({success:!0})}catch(y){console.error("❌ Failed to open PDF viewer from message:",y),s({success:!1,error:(y==null?void 0:y.message)||"Failed to open PDF viewer"})}})(),!0}}}async saveContent(e,n,s){var u,l,i,v,c,y;try{console.log("💾 Saving content:",e);try{const{data:{user:t}}=await L.auth.getUser();if(!t){const b=await chrome.storage.local.get("supabase_session"),p=b==null?void 0:b.supabase_session;p!=null&&p.access_token&&(p!=null&&p.refresh_token)&&await L.auth.setSession({access_token:p.access_token,refresh_token:p.refresh_token})}}catch(t){console.warn("Session check/set failed:",t)}let o,x;const h=e.type==="image"||e.mediaType==="image"||((u=e.metadata)==null?void 0:u.mediaType)==="image",r=e.type==="pdf";console.log("📦 Upload check:",{type:e.type,isPDF:r,isImage:h,isScreenshot:e.isScreenshot,hasPdfUrl:!!e.pdfUrl,pdfUrl:e.pdfUrl,hasContent:!!e.content,contentPreview:typeof e.content=="string"?e.content.substring(0,100):typeof e.content});try{const{data:{user:t}}=await L.auth.getUser(),b=t==null?void 0:t.id;if(console.log("👤 User check:",{userId:b,hasUser:!!t}),b&&(h||e.isScreenshot||r)){if(r){const p=e.pdfUrl||(e.url&&(e.url.endsWith(".pdf")||e.url.includes(".pdf"))?e.url:null)||(e.content&&typeof e.content=="string"&&(e.content.startsWith("http://")||e.content.startsWith("https://"))&&e.content.includes(".pdf")?e.content:null);if(console.log("📄 PDF upload attempt:",{pdfUrl:e.pdfUrl,url:e.url,content:typeof e.content=="string"?e.content.substring(0,100):"not a string",pdfUrlToUpload:p}),p){console.log("📄 Uploading PDF to Supabase Storage:",p);try{const g=await H(p,b,"pdfs");o=g.path,x=g.publicUrl,console.log("✅ PDF uploaded to storage:",o,x)}catch(g){console.error("❌ Failed to upload PDF:",g),console.error("❌ Upload error details:",{message:g.message,error:g,stack:g.stack}),x=p}}else console.warn("⚠️ PDF detected but no valid PDF URL found for upload:",{pdfUrl:e.pdfUrl,url:e.url,content:typeof e.content=="string"?e.content.substring(0,50):typeof e.content})}else if(e.content&&typeof e.content=="string"){if(e.content.startsWith("data:")){const p=await q(e.content,b,e.isScreenshot?"screenshots":"images");o=p.path,x=p.publicUrl,console.log("✅ Image uploaded from data URL:",o)}else if(e.content.startsWith("http://")||e.content.startsWith("https://")){console.log("📥 Fetching image from URL for upload:",e.content);try{const p=await H(e.content,b,e.isScreenshot?"screenshots":"images");o=p.path,x=p.publicUrl,console.log("✅ Raw image file uploaded from URL:",o,x)}catch(p){if(console.error("❌ Failed to upload image from URL:",p),(l=p.message)!=null&&l.includes("CORS")||(i=p.message)!=null&&i.includes("fetch"))console.warn("⚠️ CORS issue - storing original URL instead"),x=e.content;else throw p}}}}}catch(t){console.error("❌ Upload failed:",t)}let a=null;if((e.type==="text"||e.type==="page")&&typeof s=="number")try{const t=await chrome.tabs.sendMessage(s,{action:"getReadableArticle"});t!=null&&t.ok&&t.article&&(a=t.article)}catch{}const k={...e.metadata||{},...a?{article:{...a,htmlContent:a.content,textContent:a.textContent}}:{}};let C=e.content;(e.type==="page"||e.type==="text")&&(a!=null&&a.textContent)&&(C=a.textContent,console.log("📄 Using article textContent for page:",{textContentLength:((v=a.textContent)==null?void 0:v.length)||0,htmlContentLength:((c=a.content)==null?void 0:c.length)||0}));const m={type:e.type,title:e.title,url:e.url,content:C||e.content,notes:e.notes,tags:e.tags,timestamp:e.timestamp||new Date().toISOString(),metadata:k,storage_object_path:o,media_url:x||(h&&e.content?e.content:r&&e.pdfUrl?e.pdfUrl:void 0),media_type:h?"image":e.type==="video"?"video":r?"application/pdf":void 0,scribe_id:e.scribeId||e.scribe_id};console.log("💾 Calling StorageManager.saveContent with:",{type:m.type,title:m.title,contentLength:((y=m.content)==null?void 0:y.length)||0,hasContent:!!m.content,hasStoragePath:!!m.storage_object_path,hasMediaUrl:!!m.media_url,mediaType:m.media_type});let S;try{S=await W.saveContent(m),console.log("✅ Document saved with ID:",S)}catch(t){throw console.error("❌ StorageManager.saveContent failed:",t),console.error("❌ Save error details:",{message:t.message,error:t,stack:t.stack,data:t.data}),t}if(e.scribeId&&typeof e.scribeId=="string")try{const t=await j.getScribeById(e.scribeId),b=(t==null?void 0:t.name)||"Untitled Conversation";await j.createScribe({document_id:S,name:b})}catch(t){console.warn("⚠️ Failed to clone scribe name:",t)}else if(e.scribeName&&typeof e.scribeName=="string"&&e.scribeName.trim().length>0)try{await j.createScribe({document_id:S,name:e.scribeName.trim()}),console.log("🧠 Scribe created and linked to document:",e.scribeName)}catch(t){console.warn("⚠️ Failed to create scribe:",t)}console.log("✅ Content saved successfully with ID:",S);const z=m.type==="text"||m.type==="page"||m.type==="pdf",d=m.type==="image",f=z&&m.content&&typeof m.content=="string"&&m.content.trim().length>0,M=d&&(m.media_url||m.storage_object_path);console.log("🔍 Background: Vector processing check:",{documentId:S,type:m.type,hasContent:!!m.content,contentLength:typeof m.content=="string"?m.content.length:0,hasMediaUrl:!!m.media_url,hasStoragePath:!!m.storage_object_path,shouldProcessText:f,shouldProcessImage:M}),f?(console.log("🚀 Background: Starting vector processing for text document:",S),O.processDocument(S).then(t=>{console.log("✅ Background: Document processed for vector storage:",t)}).catch(t=>{console.error("❌ Background: Failed to process document for vectors:",t),console.error("❌ Background: Error details:",{message:t==null?void 0:t.message,stack:t==null?void 0:t.stack,error:t})})):M?(console.log("🖼️ Background: Starting image processing for vector storage:",S),O.processImage(S).then(t=>{console.log("✅ Background: Image processed for vector storage:",t),t.extractedTextLength&&console.log("📝 Background: Extracted",t.extractedTextLength,"characters from image")}).catch(t=>{console.error("❌ Background: Failed to process image for vectors:",t),console.error("❌ Background: Error details:",{message:t==null?void 0:t.message,stack:t==null?void 0:t.stack,error:t})})):console.log("⏭️ Background: Skipping vector processing:",{reason:z?m.content?typeof m.content!="string"?"content not string":m.content.trim().length===0?"empty content":"unknown":"no content":d?!m.media_url&&!m.storage_object_path?"no image URL":"unknown":"unsupported type"}),n({success:!0,id:S})}catch(o){console.error("❌ Error saving content:",o),console.error("❌ Error details:",{message:o instanceof Error?o.message:"Unknown error",error:o,stack:o instanceof Error?o.stack:void 0,data:e}),n({success:!1,error:o instanceof Error?o.message:"Unknown error"})}}handleInstallation(e){e.reason==="install"?(console.log("NabuAI extension installed successfully!"),chrome.tabs.create({url:"https://nabu-ai.com/welcome"})):e.reason==="update"&&console.log("NabuAI extension updated!")}}new Y;
